
%Main Script file for ACCENSE 

%Load sample mass cytometry data
load SPF_data ;          %Loads,
                         %1. a N x M matrix 'X' with N cells and M proteins
                         %2. N x 1 vector 'sample_ind'. Each entry in
                         %sample_ind is an integer 1-12. 1-6 corresponds to
                         %unstimulated samples in mice 1-6 and 7-12
                         %correspond to stimulated samples in mice 1-6
                         %respectively
                         %3. A M dimensional string cell 'markers' with markers{i}
                         %corresponding to the name of marker i
                         %4. A N x 2 matrix 'y_SPF' containing the
                         %embeddings computed in the paper

%Parameters
perplexity = 30;            
filename = 'ACCENSE_SPF2';
    

%Obtain 2-d embeddings
y_out = ACCENSE_embed(X, perplexity, filename);


%Identify subpopulations and record phenotypic signatures
ACCENSE_cluster(y_out,X,markers)